#include "SimController.h"

SimController::SimController(QWidget *parent) :
    QWidget(parent)
{
    setWindowFlags(Qt::WindowStaysOnTopHint);

    singleStepBtn = new QPushButton;
    singleStepBtn->setText("Single Step");

    autoStepBtn = new QPushButton;
    autoStepBtn->setText("Auto Step");

    QVBoxLayout *mainLayout = new QVBoxLayout();
    mainLayout->addWidget(singleStepBtn);
    mainLayout->addWidget(autoStepBtn);

    this->setFixedSize(160,80);

    setLayout(mainLayout);
    setWindowTitle("Sim Controller");

    connect(singleStepBtn, SIGNAL(clicked()), this, SIGNAL(singleStep()));
    connect(autoStepBtn, SIGNAL(clicked()), this, SIGNAL(autoStep()));
}
